<?PHP 
/**
* @package direct-as-a-service
* @subpackage views
*/ ?>
<!DOCTYPE html>
<html>
	<head>
	<script type="text/javascript" src="/js/jquery.min.js"></script>
	<link rel="stylesheet" type="text/css" href="/css/main.css"/>
		<title>Direct Service Authorization</title>
		<style>
			body {
				font-family: Arial, sans-serif;
			}
			.app_name { font-weight: bold; }
		</style>
	</head>
	<body>
			<?PHP if(!isset($mailbox_id_not_found)) {
				echo form_open('authorize/save_webservice_permission'); ?>
			
			<label for="app_req_access" class="hidden_context" style="display: none;">The application <?PHP echo $app_name; ?> is requesting authorization to Direct Services on your behalf.</label>
			<div>
			Authorize Direct Services for the application <span class="app_name"><?PHP echo $app_name; ?></span> on behalf of <?PHP if($is_group) {?>Group:<?PHP }?> <span class="app_name"><?PHP echo $mailbox_name;?></span>&nbsp;
			</div><br>
			<table class="display">
			<?PHP 
			echo '<tr class="report_row"><th align="center" style="width:2%;"><input class="ttHover" id="select_all" name="select_all" title="Select All" type="checkbox" onclick="javascript:toggleSelectAll(this);"/></th><th>Service</th><th>Description</th></tr>';
			foreach($user_settings as $setting) {
				$row = '<tr class="">'.
					   '<td align="center"><input type="checkbox" name="'.$setting->web_service_name.'" onclick="javascript:toggleSelectAll(this);"';
				if($setting->authorized) { 
					$row .=  'checked';
				}
				$row .= '/>'.'</td>'.
				'<td>' . $setting->web_service_name . '</td>'.
				'<td>' . $setting->web_service_description . '</td>'.
				'</tr>';
				echo $row;
			}
			?>
			</table>
			
			<div class="text-right">
				<?PHP
					$hidden_inputs = array(
						'id' =>  $app_id,
						'mailbox_name' => $mailbox_name,
						'is_group' => $is_group,
						'redirect_url' => $redirect_url,
					);
					echo form_hidden($hidden_inputs,TRUE);
				?>
				<label for="save" class="hidden_context" style="display: none;">Save <?php echo $action;?> direct service access.</label>
				<button type="submit" id="save" name="save" class="blue-button">Save</button>
				<label for="cancel_save" class="hidden_context" style="display: none;">Go back to compose page.</label>
				<button id="cancel_save" name="cancel_save" type="button" onclick="window.location = '<?PHP echo $redirect_url; ?>'" class="blue-button">Cancel</button>
			</div>
			<?PHP echo form_close(); 
			}
			else {
				#if($is_group) $mailbox_name = 'Group: '.$mailbox_name;
				#$user_feedback_message = 'Mailbox ID not found for <strong>'.$mailbox_name.'</strong>. Service Permission cannot be changed. Please contact the administrator for assistance';
				$user_feedback_message = '<p>The '.mailto($app->poc_email, $app->name).'</strong> application is requesting authorization to Direct Services '.
										 'in order to access the '.mailto($mailbox_group.'@'.DIRECT_DOMAIN).' mailbox on your behalf.  However, you cannot grant this '.
										 'permission because the account that you are logged in as ('.mailto($user->email_address()).') does not have access to this mailbox.</p>'.
										 '<p>If you believe this message to be in error, please contact the administrator for assistance.</p>';
				?>
			<label for="mailbox_id_not_found" class="hidden_context" style="display: none;">Service Permission Error: <?PHP echo strip_tags($user_feedback_message) ?></label>
			<div>
            	<p><strong>Service Permission Error</strong></p>
				<p><?PHP echo $user_feedback_message ?></p>
			</div>
			<?PHP }?>
	</body>
</html>

<script type="text/javascript">
$().ready(function() {
	toggleSelectAll(null);
});

function toggleSelectAll(checkbox) {
	var checkboxes = jQuery(':input:checkbox');

	if(checkbox == null || checkbox.id != 'select_all') {
		var allChecked = true;
		for(var i = 0; i < checkboxes.length; i++) {
			if(!checkboxes[i].checked && checkboxes[i].id != 'select_all') {
				allChecked = false;
			}
		}
		
		if(allChecked) {
			$("#select_all").attr('checked', true);
		}
		else {
			$("#select_all").attr('checked', false);
		}
	}
	else if(checkbox.id == 'select_all') {
		if(checkbox.checked) {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = true;
			}
		}
		else {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = false;
			}
		}
	}
}
</script>